﻿/// <reference path="SimpleWCFService.aspx" />

function save()
{
    // tworzy nowego klienta
    var customer = new AjaxWebServicesDemo.Customer();

    // uzyskuje dane z formularza
    customer.FirstName = $get("firstName").value;
    customer.LastName = $get("lastName").value;
    customer.Address = $get("address").value;
    customer.City = $get("city").value;
    customer.State = $get("state").value;
    customer.Zip = $get("zip").value;
        
    var timeOut = tempuri.org.SimpleService.get_timeout();
    tempuri.org.SimpleService.SaveCustomer(customer,customer,onSuccess,onFailed);
}


function clearForm()
{
    $get("firstName").value = "";
    $get("lastName").value = "";
    $get("address").value= "";
    $get("city").value= "";
    $get("state").value= "";
    $get("zip").value= "";
    
}

function onSuccess(result)
{
    // wysyła nowe dane do mechanizmu budującego tabelę
    createTableEntries(result);
    clearForm();
}


function onFailed(error)
{
    alert("Wystąpił błąd: " + error);
}

function createTableEntries(customer)
{
   var addedTable = $get("addedCustomersTable");
   var beginSpan = "<span>";
   var endSpan = "</span>";
   var newRow = addedTable.insertRow();
   var cell;
   var htmlString = new Sys.StringBuilder();
   
   // dodaje identyfikator
   cell = newRow.insertCell();
   htmlString.append(beginSpan);
   htmlString.append(customer.CustomerId);
   htmlString.append(endSpan);
   cell.innerHTML = htmlString.toString();
   htmlString.clear();
   
   // dodaje imię
   cell = newRow.insertCell();
   htmlString.append(beginSpan);
   htmlString.append(customer.FirstName);
   htmlString.append(endSpan);
   cell.innerHTML = htmlString.toString();
   htmlString.clear();

   // dodaje nazwisko
   cell = newRow.insertCell();
   htmlString.append(beginSpan);
   htmlString.append(customer.LastName);
   htmlString.append(endSpan);
   cell.innerHTML = htmlString.toString();
   htmlString.clear();

   // dodaje adres
   cell = newRow.insertCell();
   htmlString.append(beginSpan);
   htmlString.append(customer.Address);
   htmlString.append(endSpan);
   cell.innerHTML = htmlString.toString();
   htmlString.clear();

   // dodaje miasto
   cell = newRow.insertCell();
   htmlString.append(beginSpan);
   htmlString.append(customer.City);
   htmlString.append(endSpan);
   cell.innerHTML = htmlString.toString();
   htmlString.clear();

   // dodaje województwo
   cell = newRow.insertCell();
   htmlString.append(beginSpan);
   htmlString.append(customer.State);
   htmlString.append(endSpan);
   cell.innerHTML = htmlString.toString();
   htmlString.clear();

   // dodaje kod
   cell = newRow.insertCell();
   htmlString.append(beginSpan);
   htmlString.append(customer.Zip);
   htmlString.append(endSpan);
   cell.innerHTML = htmlString.toString();
   htmlString.clear();


}